/******************************************/
/* Sound Splitter 0.1                     */
/* Copyright (c) Owen Rudge 2001          */
/******************************************/

/* Started:              ~16/10/2001 16:28:07 BST */
/* Got Working Properly: ~16/10/2001 17:24:30 BST */

/* Just thought I'd note that down. :-) */

#if defined(DJGPP) || defined(MINGW32)
   #define GCC
#endif

#include <stdlib.h>
#include <string.h>

#ifdef GCC
   #include <unistd.h>
#endif

#include <stdio.h>
#include <math.h>
#include <io.h>

/* The file_* functions below are from Allegro
   (http://alleg.sourceforge.net/ */
   
int file_igetw(FILE *f)
{
   int b1, b2;

   if ((b1 = getc(f)) != EOF)
      if ((b2 = getc(f)) != EOF)
         return ((b2 << 8) | b1);

   return EOF;
}

long file_igetl(FILE *f)
{
   int b1, b2, b3, b4;

   if ((b1 = getc(f)) != EOF)
      if ((b2 = getc(f)) != EOF)
         if ((b3 = getc(f)) != EOF)
            if ((b4 = getc(f)) != EOF)
               return (((long)b4 << 24) | ((long)b3 << 16) |
               ((long)b2 << 8) | (long)b1);

   return EOF;
}

long file_iputl(long l, FILE *f)
{
   int b1, b2, b3, b4;

   b1 = (int)((l & 0xFF000000L) >> 24);
   b2 = (int)((l & 0x00FF0000L) >> 16);
   b3 = (int)((l & 0x0000FF00L) >> 8);
   b4 = (int)l & 0x00FF;

   if (putc(b4,f)==b4)
      if (putc(b3,f)==b3)
         if (putc(b2,f)==b2)
            if (putc(b1,f)==b1)
               return l;

   return EOF;
}

int file_iputw(int w, FILE *f)
{
   int b1, b2;

   b1 = (w & 0xFF00) >> 8;
   b2 = w & 0x00FF;

   if (putc(b2,f)==b2)
      if (putc(b1,f)==b1)
         return w;

   return EOF;
}
   
#include <fcntl.h>
#include <sys/stat.h>
   
long get_file_size(char *fn)
{
   int tmp;
   long retval;
      
   tmp = open(fn, O_RDONLY | O_BINARY);
   retval = filelength(tmp);
   close(tmp);
   return(retval);
}

int main(int argc, char *argv[])
{
   char tmpdest[200];
#ifdef USE_ALLEGRO_FUNCTIONS
   PACKFILE *f, *dest, *dest_new;
#else
   FILE *f, *dest, *dest_new;
#endif
   char buffer[25];
   int i, j;
   long length, len;
   int freq = 22050;
   int bits = 8;
   int channels = 1;
   signed short s;
   char *bigbuffer;
   long size, fs;
   int bps;
   char old_fn[200];
   int newlen = 1;
   double tmpd;
   long bytesdone = 0;
   int fulllen = 0;
   long old_size;

#ifdef USE_ALLEGRO_FUNCTIONS
   install_allegro(SYSTEM_NONE, &errno, &atexit);
#endif

   printf("SplitSound 0.1\n");
   printf("Copyright (c) Owen Rudge 2001\n");
   printf("\n");

   if (argc != 2 && argc != 3 && argc != 4)
   {
      printf("Syntax: %s src [len [--full]]\n", argv[0]);
      printf("\n");
      printf("Parameters:\n");
      printf("  src    - The source WAV file (minus extension - IMPORTANT!)\n");
      printf("\n");
      printf("  len    - Length of files to be generated, in seconds. If not\n");
      printf("           supplied, len defaults to 1.\n");
      printf("\n");
      printf("  --full - If present, the last file will be full-length, with the\n");
      printf("           'empty' seconds remaining. All files will be 'len'\n");
      printf("           seconds. This parameter can only be used if len is\n");
      printf("           specified.\n");
      printf("\n");
      printf("Web site: http://www.owenrudge.co.uk/\n");
      printf("E-mail:   splitsnd@orudge.freeuk.com\n");
      return(1);
   }

   if (argc >= 3)
   {
      newlen = atoi(argv[2]);

      if (newlen <= 0)
      {
         printf("Warning: len <= 0, resetting to 1\n");
         newlen = 1;
      }
      
      if (argc == 4)
      {
         if (strcmp(argv[3], "--full") == 0)
            fulllen = 1;
      }
   }

#ifdef DEBUG
   printf("DEBUG: newlen = %d\n", newlen);
   getch();
#endif

   sprintf(tmpdest, "%s.wav", argv[1]);
   f = fopen(tmpdest, "rb");

   if (f == NULL)
   {
      printf("Unable to open %s.wav\n", argv[1]);
      return(1);
   }

   fread(buffer, 12, 1, f);          /* check RIFF header */
   
   if (memcmp(buffer, "RIFF", 4) || memcmp(buffer+8, "WAVE", 4))
      goto getout;

   printf("Splitting %s into %d second pieces...\n\n", tmpdest, newlen);

   while (!feof(f)) //!pack_feof(f))
   {
      if (fread(buffer, 4, 1, f) != 1)
         break;

      length = file_igetl(f);          /* read chunk length */

      if (memcmp(buffer, "fmt ", 4) == 0)
      {
         i = file_igetw(f);            /* should be 1 for PCM data */
         length -= 2;

         if (i != 1)
         {
            printf("This file is not a PCM WAV file. The format ID is set to %d.\nAt present, SplitSound can only handle PCM files.", i);
            goto getout;
         }

         channels = file_igetw(f);     /* mono or stereo data */
         length -= 2;
         if ((channels != 1) && (channels != 2))
            goto getout;

         freq = file_igetl(f);         /* sample frequency */
         length -= 4;

         file_igetl(f);                /* skip six bytes */
         file_igetw(f);
         length -= 6;

         bits = file_igetw(f);         /* 8 or 16 bit data? */
          length -= 2;
         if ((bits != 8) && (bits != 16))
             goto getout;
      }
      else if (memcmp(buffer, "data", 4) == 0)
      {
         len = length / channels;

         if (bits == 16)
            len /= 2;

#ifdef DEBUG
         printf("DEBUG: (len / freq)/newlen = %d\n", (len/freq)/newlen);
         printf("DEBUG: (%d / %d) / %d = %d\n", len, freq, newlen, (len/freq)/newlen);
         getch();
#endif

         tmpd = ((double)len/freq) / (double) newlen;
         
         if (tmpd <= (double) 1.0)
         {
            printf("Error: chunk size larger than original file.\n");
            goto getout;
         }

         for (j = 0; j < ceil((double)(len / freq)/newlen); j++)
         {
            printf("Creating %s%03d.wav...", argv[1], j);
            
            sprintf(tmpdest, "%s%03d.wav.tmp", argv[1], j);
            dest = fopen(tmpdest, "wb");

            bps = (bits / 8) * channels;
            fwrite("WAVEfmt ", 8, 1, dest);
            file_iputl(16, dest);
            file_iputw(1, dest);  // PCM
            file_iputw(channels, dest);
            file_iputl(freq, dest);
            file_iputl(freq * bps, dest);
            file_iputw(bps, dest);
            file_iputw(bits, dest);
            fwrite("data", 4, 1, dest);

/*            printf("\nNOTE: length - ((freq * (bits / 8) * channels) * newlen)\n");
            printf("NOTE: %ld - ((%d * (%d / 8) * %d) * %d)\n", length, freq, bits, channels, newlen);
            printf("NOTE: size = %ld", length - ((freq * (bits / 8) * channels)*newlen));
            printf("\n");
            printf("j = %d, cel((dou......) = %d\n", j, ceil((double)(len/freq)/newlen));*/

            if (j == ceil((double)(len/freq)/newlen)-1) // may not be a complete x seconds
            {
               if (fulllen == 0)
                  size = length - bytesdone;
               else
                  size = old_size;
            }
               //printf("\n\n\nlen - ((freq * (bits / 8) * chan) * newlen\n");
//               printf("\n%ld - ((%d * (%d / 8) * %d) * %d\n", len, freq, bits, channels, newlen);
               
//               size = length - ((freq * (bits / 8) * channels)*newlen); }
//               size = length - bytesdone;
            else
               old_size = size = ((freq * (bits / 8) * channels)*newlen);

#ifdef DEBUG
            printf("DEBUG: size = %ld", size);
#endif
            bytesdone += size;
            
            bigbuffer = malloc(size);
            memset(bigbuffer, 0, size);
            
            fread(bigbuffer, size, 1, f);
            file_iputl(size, dest);
            fwrite(bigbuffer, size, 1, dest);

            if (bigbuffer) free(bigbuffer);
            
            fclose(dest);
            dest = fopen(tmpdest, "rb");

            fs = get_file_size(tmpdest);

            strcpy(old_fn, tmpdest);

            printf("..");
            
            sprintf(tmpdest, "%s%03d.wav", argv[1], j);
            dest_new = fopen(tmpdest, "wb");

            fwrite("RIFF", 4, 1, dest_new);
            file_iputl(fs, dest_new);

            bigbuffer = malloc(fs);

            fread(bigbuffer, fs, 1, dest);
            fwrite(bigbuffer, fs, 1, dest_new);
            free(bigbuffer);

            fclose(dest);
            fclose(dest_new);

            unlink(old_fn);
            printf(".done\n");
         }
         
/*            if (bits == 8) {
               pack_fread(spl->data, length, f);
            }
            else {
               for (i=0; i<len*channels; i++) {
                  s = pack_igetw(f);
                  ((signed short *)spl->data)[i] = s^0x8000;
               }
            }*/
            length = 0;
       }
//   }

      while (length > 0) {             /* skip the remainder of the chunk */
         if (getc(f) == EOF)
            break;

         length--;
      }
   }
   
getout: ;
   fclose(f);
   return(0);
}
