'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 3D Controls Function                                          '
' Visual Basic Workshop                                         '
' http://www.orudge.freeuk.com/16bit/control3d.htm              '
' Created by Owen Rudge                                         '
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long

Const COLOR_BTNSHADOW = 16
Const COLOR_BTNHIGHLIGHT = 20

Sub MakeForm3D (frmForm As Form)
    On Error Resume Next       ' Could run into problems with invisible controls
    Dim DarkGrey As Long, White As Long
    Dim i As Integer, dw As Integer
    Dim CTop As Integer, CLeft As Integer, CRight As Integer, CBottom As Integer
 
    ' Outline a form's controls if the control's Tag
    ' property contains -3D-
    
    Dim CName As Control
    
    DarkGrey = GetSysColor(COLOR_BTNSHADOW)
    White = GetSysColor(COLOR_BTNHIGHLIGHT)
    
    dw = frmForm.DrawWidth
    frmForm.DrawWidth = 1
    For i = 0 To (frmForm.Controls.Count - 1)
        Set CName = frmForm.Controls(i)
        If TypeOf CName Is Menu Then
            ' Menu control

            ' NOTE: Should check for Common Dialog, etc
        ElseIf InStr(UCase(CName.Tag), "-3D-") <> 0 Then
            CTop = CName.Top - Screen.TwipsPerPixelY
            CLeft = CName.Left - Screen.TwipsPerPixelX
            CRight = CName.Left + CName.Width
            CBottom = CName.Top + CName.Height
            frmForm.Line (CLeft, CTop)-(CRight, CTop), DarkGrey
            frmForm.Line (CLeft, CTop)-(CLeft, CBottom), DarkGrey
            frmForm.Line (CLeft, CBottom)-(CRight, CBottom), White
            frmForm.Line (CRight, CTop)-(CRight, CBottom), White
        End If
    Next i
    frmForm.DrawWidth = dw       ' Restore DrawWidth
End Sub

